/*
 * Decompiled with CFR 0.152.
 */
public class DH {
    private long gen;
    private long mod;
    private long priv;
    private long pub;
    private long key;
    private long maxNum = Integer.MAX_VALUE;
    private static final int DH_MAX_BITS = 31;
    private static final int DH_RANGE = 100;
    private static final int DH_MOD = 1;
    private static final int DH_GEN = 2;
    private static final int DH_PRIV = 3;
    private static final int DH_PUB = 4;
    private static final int DH_KEY = 5;

    public DH() {
    }

    public DH(long l, long l2) throws Exception {
        if (l >= this.maxNum || l2 >= this.maxNum) {
            throw new Exception("Modulus or generator too large.");
        }
        this.gen = l;
        this.mod = l2;
    }

    private long rng(long l) {
        return (long)(Math.random() * (double)l);
    }

    private boolean millerRabin(long l, int n) {
        long l2 = 0L;
        int n2 = 0;
        while (n2 < n) {
            l2 = this.rng(l - 3L) + 2L;
            if (this.XpowYmodN(l2, l - 1L, l) != 1L) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private long generatePrime() {
        long l;
        long l2 = 0L;
        while ((l2 = this.tryToGeneratePrime(l = this.rng(this.maxNum))) == 0L) {
        }
        return l2;
    }

    private long tryToGeneratePrime(long l) {
        if ((l & 1L) == 0L) {
            ++l;
        }
        long l2 = 0L;
        while (!this.millerRabin(l, 25) && l2++ < 100L && l < this.maxNum) {
            if ((l += 2L) % 3L != 0L) continue;
            l += 2L;
        }
        return l2 >= 100L || l >= this.maxNum ? 0L : l;
    }

    private long XpowYmodN(long l, long l2, long l3) {
        long l4 = 1L;
        int n = 0;
        while (n < 64) {
            l4 = l4 * l4 % l3;
            if ((l2 & Long.MIN_VALUE) != 0L) {
                l4 = l4 * l % l3;
            }
            l2 <<= 1;
            ++n;
        }
        return l4;
    }

    public void createKeys() {
        this.gen = this.generatePrime();
        this.mod = this.generatePrime();
        if (this.gen > this.mod) {
            long l = this.gen;
            this.gen = this.mod;
            this.mod = l;
        }
    }

    public long createInterKey() {
        this.priv = this.rng(this.maxNum);
        this.pub = this.XpowYmodN(this.gen, this.priv, this.mod);
        return this.pub;
    }

    public long createEncryptionKey(long l) throws Exception {
        if (l >= this.maxNum) {
            throw new Exception("interKey too large");
        }
        this.key = this.XpowYmodN(l, this.priv, this.mod);
        return this.key;
    }

    public long getValue(int n) {
        switch (n) {
            case 1: {
                return this.mod;
            }
            case 2: {
                return this.gen;
            }
            case 3: {
                return this.priv;
            }
            case 4: {
                return this.pub;
            }
            case 5: {
                return this.key;
            }
        }
        return 0L;
    }

    public int bits(long l) {
        int n = 0;
        while (n < 64) {
            if ((l /= 2L) < 2L) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public static byte[] longToBytes(long l) {
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray[n] = (byte)(0xFFL & l >> 8 * (7 - n));
            ++n;
        }
        return byArray;
    }

    public static long bytesToLong(byte[] byArray) {
        long l = 0L;
        int n = 0;
        while (n < 8) {
            l <<= 8;
            l += (long)byArray[n];
            ++n;
        }
        return l;
    }
}

