/*
 * Copyright (c) 2003 Benedikt Meurer (benedikt.meurer@unix-ag.uni-siegen.de)
 *               2004 Jean-François Wauthy (pollux@xfce.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif /* !HAVE_CONFIG_H */

#include <gtk/gtk.h>

#include <libxfce4util/libxfce4util.h>

#include "pprint_page.h"

static void pprint_page_class_init (PprintPageClass *);
static void pprint_page_init (PprintPage *);
static void pprint_page_finalize (GObject *);

static GtkWidgetClass *parent_class = NULL;

GtkType
pprint_page_get_type (void)
{
  static GtkType pprint_page_type = 0;

  if (!pprint_page_type) {
    static const GTypeInfo pprint_page_info = {
      sizeof (PprintPageClass),
      NULL,
      NULL,
      (GClassInitFunc) pprint_page_class_init,
      NULL,
      NULL,
      sizeof (PprintPage),
      0,
      (GInstanceInitFunc) pprint_page_init,
      NULL
    };

    pprint_page_type = g_type_register_static (GTK_TYPE_TABLE, "PprintPage", &pprint_page_info, 0);
  }

  return (pprint_page_type);
}

static void
pprint_page_class_init (PprintPageClass * klass)
{
  GObjectClass *object_class;

  object_class = G_OBJECT_CLASS (klass);
  object_class->finalize = pprint_page_finalize;

  parent_class = gtk_type_class (gtk_table_get_type ());
}

static void
pprint_page_init (PprintPage * pg)
{
  GtkWidget *label;

  gtk_container_set_border_width (GTK_CONTAINER (pg), 6);
  gtk_table_resize (GTK_TABLE (pg), 3, 2);
  gtk_table_set_col_spacings (GTK_TABLE (pg), 4);
  gtk_table_set_row_spacings (GTK_TABLE (pg), 4);
  gtk_table_set_homogeneous (GTK_TABLE (pg), FALSE);

  /* see a2ps documentation for more information on the string meaning */
  label = gtk_label_new (_("Language:"));
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (pg), label, 0, 1, 0, 1, GTK_FILL, 0, 0, 0);

  pg->lang = gtk_combo_new ();
  gtk_widget_show (pg->lang);
  gtk_table_attach (GTK_TABLE (pg), pg->lang, 1, 2, 0, 1, GTK_EXPAND | GTK_FILL, 0, 0, 0);

  /* see a2ps documentation for more information on the string meaning */
  label = gtk_label_new (_("Highlight level:"));
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
  gtk_widget_show (label);
  gtk_editable_set_editable (GTK_EDITABLE (GTK_COMBO (pg->lang)->entry), FALSE);
  gtk_combo_set_value_in_list (GTK_COMBO (pg->lang), TRUE, FALSE);
  gtk_table_attach (GTK_TABLE (pg), label, 0, 1, 1, 2, GTK_FILL, 0, 0, 0);

  pg->highlight = gtk_combo_new ();
  gtk_widget_show (pg->highlight);
  gtk_editable_set_editable (GTK_EDITABLE (GTK_COMBO (pg->highlight)->entry), FALSE);
  gtk_combo_set_value_in_list (GTK_COMBO (pg->highlight), TRUE, FALSE);
  gtk_table_attach (GTK_TABLE (pg), pg->highlight, 1, 2, 1, 2, GTK_EXPAND | GTK_FILL, 0, 0, 0);

  /* see a2ps documentation for more information on the string meaning */
  label = gtk_label_new (_("Strip level:"));
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
  gtk_widget_show (label);
  gtk_table_attach (GTK_TABLE (pg), label, 0, 1, 2, 3, GTK_FILL, 0, 0, 0);

  pg->strip = gtk_spin_button_new_with_range (0.0, 3.0, 1.0);
  gtk_widget_show (pg->strip);
  gtk_table_attach (GTK_TABLE (pg), pg->strip, 1, 2, 2, 3, GTK_EXPAND | GTK_FILL, 0, 0, 0);
}

static void
pprint_page_finalize (GObject * object)
{
  g_return_if_fail (object != NULL);
  g_return_if_fail (PPRINT_IS_PAGE (object));

  G_OBJECT_CLASS (parent_class)->finalize (object);
}

GtkWidget *
pprint_page_new (void)
{
  PprintPage *pg;
  GList *list;

  pg = PPRINT_PAGE (g_object_new (pprint_page_get_type (), NULL));

  if ((list = xfprint_option_list (languages)) != NULL) {
    gtk_combo_set_popdown_strings (GTK_COMBO (pg->lang), list);
    g_list_free (list);
  }

  if ((list = xfprint_option_list (hilevels)) != NULL) {
    gtk_combo_set_popdown_strings (GTK_COMBO (pg->highlight), list);
    g_list_free (list);
  }

  return (GTK_WIDGET (pg));
}

void
pprint_page_set_settings (PprintPage * pg, const XfprintSettingsPrettyPrint * pp)
{
  g_return_if_fail (pg != NULL);
  g_return_if_fail (pp != NULL);

  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (pg->lang)->entry), xfprint_option_alias (languages, pp->language));
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (pg->highlight)->entry), xfprint_option_alias (hilevels, pp->highlight));
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (pg->strip), pp->strip);
}

void
pprint_page_get_settings (PprintPage * pg, XfprintSettingsPrettyPrint * pp)
{
  g_return_if_fail (pg != NULL);
  g_return_if_fail (pp != NULL);

  pp->language = xfprint_option_name (languages, gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (pg->lang)->entry)));

  pp->highlight = xfprint_option_name (hilevels, gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (pg->highlight)->entry)));

  pp->strip = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (pg->strip));
}
