//
// selection.cpp
//
// Part of KDVI - A previewer for TeX DVI files.
//
// (C) 2001--2004 Stefan Kebekus
// Distributed under the GPL

#include <qapplication.h>
#include <qclipboard.h>

#include "selection.h"



void textSelection::set(PageNumber pageNr, Q_INT32 start, Q_INT32 end, const QString &text)
{
  Q_UINT16 oldpage    = page;
  bool     oldIsEmpty = isEmpty();
  
  page              = pageNr;
  selectedTextStart = start;
  selectedTextEnd   = end;
  if (page != 0)
    selectedText = text;
  else
    selectedText = QString::null;
  
  if (page != 0) {
    QApplication::clipboard()->setSelectionMode(true);
    QApplication::clipboard()->setText(selectedText);
  }

  // If the state of the selection has changed, emit the appropriate
  // signals
  if (isEmpty() != oldIsEmpty)
    emit selectionIsNotEmpty( !isEmpty() );
  if (page != oldpage)
    emit pageChanged();
}


void textSelection::copyText(void) const
{
  if (!isEmpty()) {
    QApplication::clipboard()->setSelectionMode(false);
    QApplication::clipboard()->setText(selectedText);
  }
}


void textSelection::clear(void)
{
  set(0, -1, -1, QString::null);
}


#include "selection.moc"
