/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2004 by Stanislav Visnovsky
                            <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */
#ifndef KBPROJECT_H
#define KBPROJECT_H

#include <qstring.h>

#include <kconfig.h>
#include "catalogsettings.h"
#include "projectsettings.h"

namespace KBabel
{

    class Project : public QObject, public KShared
    {
	    Q_OBJECT
	public:
	    typedef KSharedPtr <Project> Ptr;

	    Project( const QString& file );
	    virtual ~Project ();
	    
	    QString filename () const { return _filename; }
	    QString name () const { return _name; }
	    
	    void setName( const QString& name ) { _name = name; }

	    KConfig* config ();
	    
	    IdentitySettings identitySettings ();
	    SaveSettings saveSettings ();
	    MiscSettings miscSettings ();
	    SpellcheckSettings spellcheckSettings ();
	    SourceContextSettings sourceContextSettings ();
	    CatManSettings catManSettings ();
	    
	    void setSettings(KBabel::CatManSettings newSettings);
	    void setSettings(KBabel::SaveSettings newSettings);
	    void setSettings(KBabel::IdentitySettings newSettings);
	    void setSettings(KBabel::MiscSettings newSettings);
	    void setSettings(KBabel::SpellcheckSettings newSettings);
	    void setSettings(KBabel::SourceContextSettings newSettings);
	    
	signals:
	    void signalIdentitySettingsChanged();
	    void signalSaveSettingsChanged();
	    void signalMiscSettingsChanged();
	    void signalSpellcheckSettingsChanged();
	    void signalSourceContextSettingsChanged();
	    void signalCatManSettingsChanged();

	    /**
	    * This is general purpose signal emitted additionally
	    * to the signals above.
	    */	    
	    void signalSettingsChanged();

	private:
	    QString _filename;
	    QString _name;
	    KConfig* _config;
    };

}

#endif // KBPROJECT_H
