/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qpixmap.h>

#include <kapplication.h>
#include <dcopclient.h>

#include "k_mnu.h"
#include "client_mnu.h"

#include "menumanager.h"
#include "menumanager.moc"

MenuManager::MenuManager( PanelKMenu* menu, QObject *parent, const char *name )
    : QObject( parent, name ), DCOPObject( name )
{
    panelmenu = menu;
    clientmenus.setAutoDelete( TRUE );
    kapp->dcopClient()->setNotifications(true);
    connect( kapp->dcopClient(), SIGNAL( applicationRemoved(const QCString&) ),
	     this, SLOT( applicationRemoved( const QCString& ) ) );
}

MenuManager::~MenuManager()
{
}

QCString MenuManager::createMenu( QPixmap icon, QString text )
{
    static int menucount = 0;
    menucount++;
    QCString name;
    name.sprintf("kickerclientmenu-%d", menucount );
    KickerClientMenu* p = new KickerClientMenu( 0, name );
    clientmenus.append(p);
    panelmenu->initialize();
    p->text = text;
    p->icon = icon;
    p->idInParentMenu = panelmenu->insertClientMenu( p );
    p->createdBy = kapp->dcopClient()->senderId();
    panelmenu->adjustSize();
    return name;
}

void MenuManager::removeMenu( QCString menu )
{
    for( QPtrListIterator<KickerClientMenu> it( clientmenus);
         it.current(); ++it ) {
	KickerClientMenu* m = it.current();
	if ( m->objId() == menu ) {
	    panelmenu->removeClientMenu( m->idInParentMenu );
	    clientmenus.removeRef( m );
	}
    }
    panelmenu->adjustSize();
}


void MenuManager::applicationRemoved( const QCString& appRemoved)
{
    for( QPtrListIterator<KickerClientMenu> it( clientmenus);
         it.current(); ++it ) {
	KickerClientMenu* m = it.current();
	if ( m->createdBy == appRemoved ) {
	    panelmenu->removeClientMenu( m->idInParentMenu );
	    clientmenus.removeRef( m );
	}
    }
    panelmenu->adjustSize();
}

bool MenuManager::process(const QCString &fun, const QByteArray &data,
				QCString &replyType, QByteArray &replyData)
{
    if ( fun == "createMenu(QPixmap,QString)" ) {
	QDataStream dataStream( data, IO_ReadOnly );
	QPixmap icon;
	QString text;
	dataStream >> icon >> text;
	QDataStream reply( replyData, IO_WriteOnly );
	reply << createMenu( icon, text );
	replyType = "QCString";
	return TRUE;
    } else if ( fun == "removeMenu(QCString)" ) {
	QDataStream dataStream( data, IO_ReadOnly );
	QCString menu;
	dataStream >> menu;
	removeMenu( menu );
	replyType = "void";
	return TRUE;
    }
    return FALSE;
}
