// -*- Mode: C++; c-basic-offset: 2; indent-tabs-mode: nil; tab-width: 8; -*-

/***************************************************************************
    norsswidget.cpp
    Marcus Camen  <mcamen@mcamen.de>
***************************************************************************/

/*
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; see the file COPYING.LIB.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
*/

#include <qlayout.h>
#include <qsizepolicy.h>
#include <dcopref.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kpushbutton.h>
#include <kdebug.h>
#include <kdialogbase.h>
#include "sidebarsettings.h"
#include "configfeeds.h"
#include "norsswidget.h"


namespace KSB_News {

  NoRSSWidget::NoRSSWidget(QWidget *parent, const char *name) : QWidget(parent, name) {
    QVBoxLayout *topLayout = new QVBoxLayout(this);

    topLayout->addStretch();

    KPushButton *btn = new KPushButton( i18n("&Configure"), this );
    btn->setSizePolicy( QSizePolicy::Fixed, QSizePolicy::Minimum );
    connect( btn, SIGNAL( clicked() ), this, SLOT( slotBtnClicked() ) );
    topLayout->addWidget( btn, 0, Qt::AlignHCenter );

    topLayout->addStretch();
  }


  void NoRSSWidget::slotBtnClicked() {
    m_confdlg = new KDialogBase( this, "settings", true,
                                 i18n( "RSS Settings" ),
                                 KDialogBase::Ok|KDialogBase::Cancel,
                                 KDialogBase::Ok, false );
    m_confdlg->setMainWidget( new ConfigFeeds( m_confdlg, "rssdlg" ) );
    connect( m_confdlg, SIGNAL( okClicked() ),
             SLOT( slotConfigure_okClicked() ) );
    m_confdlg->show();
  }


  void NoRSSWidget::slotConfigure_okClicked() {
    DCOPRef rss_document("rssservice", "RSSService");

    // get new list of sources
    ConfigFeeds *mainwgt = static_cast<ConfigFeeds*>( m_confdlg->mainWidget() );
    QStringList m_our_rsssources = mainwgt->getFeedlist();

    // add new sources
    QStringList::iterator it;
    for ( it = m_our_rsssources.begin(); it != m_our_rsssources.end(); ++it ) {
      rss_document.call( "add", ( *it ) );
    }

    // save configuration to disk
    SidebarSettings::setSources(m_our_rsssources);
    SidebarSettings::writeConfig();

    // destroy dialog
    m_confdlg->delayedDestruct();
    m_confdlg = 0;
  }

} // namespace KSB_News

#include "norsswidget.moc"
