/*-
 * customsA2L.c --
 *	Convert an argv-style string into a lst of strings
 *
 * Copyright (c) 1988, 1989 by the Regents of the University of California
 * Copyright (c) 1988, 1989 by Adam de Boor
 * Copyright (c) 1989 by Berkeley Softworks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any non-commercial purpose
 * and without fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California,
 * Berkeley Softworks and Adam de Boor make no representations about
 * the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 */
#ifndef lint
static char *rcsid =
"$Id: customsA2L.c,v 1.1 1994/05/18 23:00:01 stolcke Exp $ ICSI (Berkeley)";
#endif /* not lint */

#include    <string.h>

#include    "customs.h"


/*-
 *-----------------------------------------------------------------------
 * Customs_ArgvToLst
 *	Convert an argv-style string into a lst of strings.
 *
 * Results:
 *	The list, and the length of the argv buffer if requested.
 *
 * Side Effects:
 *	None.
 *
 *-----------------------------------------------------------------------
 */
Lst
Customs_ArgvToLst (argv, lenPtr)
    char	*argv;
    int		*lenPtr;
{
    Lst lst;
    char *cp, *s;
    int len;

    lst = NILLST;
    for (cp = argv; *cp; cp += len) {
	len = strlen (cp) + 1;
	s = (char *)emalloc (len);
	strcpy (s, cp);

	if (lst == NILLST) {
	    lst = Lst_Init (FALSE);
	}
	(void)Lst_AtEnd (lst, (ClientData)s);
    }

    if (lenPtr) {
	*lenPtr = cp - argv + 1;
    }
    return (lst);
}

