.\" Copyright 2000 Perforce Software
.\" $Id: //depot/r05.2/p4-doc/man/p4.1#1 $
.TH P4 1 "7 July 2001"
.SH NAME
p4 \- Perforce source management system client
.SH SYNOPSIS
.B p4
[
.BI options
]
.BI command
.BI arg ...
.SH DESCRIPTION
.B p4
is the client program used to interact with the
source management system repository server.

.SH OPTIONS
.TP
.B -c \fIclient\fP
The -c flag specifies the client name, overriding the value of
$P4CLIENT in the environment and the default (the hostname).
.TP
.B -d \fIdirectory\fP
The -d flag specifies the current directory, overriding the value of
$PWD in the environment and the default (the current directory).
.TP
.B -H \fIhost\fP
The -H flag specifies the host name, overriding the value of
$P4HOST in the environment and the default (the hostname).
.TP
.B -p \fIport\fP
The -p flag specifies the server's listen address, overriding the
value of $P4PORT in the environment and the default (perforce:1666).
.TP
.B -P \fIpassword\fP
The -P flag specifies the password, overriding the value of
$P4PASSWD in the environment.
.TP
.B -s
The -s flag causes the p4 client program to prefix each line of
output with a tag (error, warning, info, text, exit) so as to make
it amenable to scripting.
.TP
.B -u \fIuser\fP
The -u flag specifies the user name, overriding the value of
$P4USER, $USER, and $USERNAME in the environment.
.TP
.B -v \fIx\fP
The -v flag sets the debug output level.
.TP
.B -x \fIfile\fP
The -x flag instructs p4 to read arguments, one per line, from the
named file.  If the file is named '-', then standard input is read.
.TP
.B -V
The -V flag displays the version of the p4 client command and exits.

.SH USAGE
.B p4
is the client interface for the
.SM Perforce
source management system.
.B p4
connects to the server daemon,
.B p4d,
which manages access to the central respository, or depot. 
.B p4 
uses environment variable
.B $P4PORT
to determine the connection address of the server daemon (using
.B perforce:1666
as default).  Each
.B p4
client workspace is identified by a name,
determined by the environment variable
.B $P4CLIENT
(using hostname as default.)
Information associated with each client workspace includes
a root directory in the client machine file system and a view definition
which provides a mapping between file names on the client and files in
the depot.  This information is maintained in the depot database.
.LP
The following commands are recognized:
.LP
.nf
    add        Open a new file to add it to the depot
    admin      Perform administrative operations on the server
    branch     Create or edit a branch specification
    branches   Display list of branches
    change     Create or edit a changelist description
    changes    Display list of pending and submitted changelists
    client     Create or edit a client specification and its view
    clients    Display list of known clients
    counter    Display, set, or delete a counter
    counters   Display list of known counters
    delete     Open an existing file to delete it from the depot
    depot      Create or edit a depot specification
    depots     Display list of depots
    describe   Display a changelist description
    diff       Display diff of client file with depot file
    diff2      Display diff of two depot files
    dirs       List subdirectories of a given depot directory
    edit       Open an existing file for edit
    filelog    List revision history of files
    files      List files in the depot
    fix        Mark jobs as being fixed by named changelists
    fixes      List what changelists fix what job
    flush      Fake a 'p4 sync' by not moving files
    fstat      Dump file info
    group      Change members of a user group
    groups     List groups (of users)
    have       List revisions last synced
    help       Print this help message
    info       Print out client/server information
    integrate  Schedule integration from one file to another
    integrated Show integrations that have been submitted
    job        Create or edit a job (defect) specification
    jobs       Display list of jobs
    jobspec    Edit the job template
    label      Create or edit a label specification and its view
    labels     Display list of labels
    labelsync  Synchronize label with the current client contents
    lock       Lock an opened file against changelist submission
    obliterate Remove files and their history from the depot
    opened     Display list of files opened for pending changelist
    passwd     Set the user's password on the server (and Windows client)
    print      Retrieve a depot file to the standard output
    protect    Modify protections in the server namespace
    rename     Explains how to rename files
    reopen     Change the type or changelist number of an opened file
    resolve    Merge open files with other revisions or files
    resolved   Show files that have been merged but not submitted
    revert     Discard changes from an opened file
    review     List and track changelists (for the review daemon)
    reviews    Show what users are subscribed to review files
    set        Set variables in the registry (Windows only)
    submit     Submit open files to the depot
    sync       Synchronize the client with its view of the depot
    triggers   Modify list of pre-submit triggers
    typemap    Modify the file name-to-type mapping table
    unlock     Release a locked file but leave open
    user       Create or edit a user specification
    users      Display list of known users
    verify     Verify that the server archives are intact
    where      Show how file names map through the client view
.fi

.SH COMMANDS

.TP
.B p4 add [ -c changelist# ] [ -t filetype ] file ...
.IP
Open a new file for adding to the depot. If the file exists
on the client it is read to determine if it is text or binary.
If it does not exist it is assumed to be text. The file must
either not exist in the depot, or it must be deleted at the
current head revision. Files may be deleted and re-added.
.IP
If the -c flag is given the open files are associated with the
specified pending changelist number; otherwise the open files are
associated with the default changelist.
.IP
If file is already open it is moved into the specified pending
changelist. It is not permissible to reopen a file for add unless
it was already open for add.
.IP
If -t filetype is given the file is explicitly opened as that
filetype. Otherwise, the filetype is determined by the file
name-to-type mapping table managed by "p4 typemap". If the file
name is not mapped in that table, "p4 add" senses the filetype
by examining the file"s contents and execution permission bits.
See "p4 help filetypes" for a complete list.
.TP
.B p4 admin checkpoint [ -z ] [ prefix ]
.TP
.B p4 admin stop
.IP
"p4 admin checkpoint" causes the server to take a checkpoint and
to copy the journal to a numbered journal file. It is equivalent
to "p4d -jc".
.IP
The -z flag causes the checkpoint and saved journal to be saved in
compressed (gzip) format, with the ".gz" suffix on the file names.
.IP
If a prefix is specified, the files will be named prefix.ckp.n and
prefix.jnl.n respectively, where n is a sequence number. Without
prefix, the default filenames checkpoint.n and journal.n will be
used.
.IP
"p4 admin stop" stops the server, terminating any requests
currently running. It first locks the database to ensure that
no updates are taking place, but otherwise is brutal as it does
not wait for users to finish what they are doing.
(For NT users, this will work whether you are running Perforce
as a server or a service.)
.TP
.B p4 branch [ -f ] name
.TP
.B p4 branch -d [ -f ] name
.TP
.B p4 branch -o name
.TP
.B p4 branch -i [ -f ]
.IP
Create a new branch specification or edit an existing branch
specification. The specification form is put into a temporary
file and the editor (given by the environment variable $P4EDITOR)
is invoked.
.IP
The branch specification form contains the following fields:
.RS
.TP
Branch:
The branch name (read only.)
.RE
.RS
.TP
Owner:
The user who created this branch. Can be changed.
.RE
.RS
.TP
Update:
The date specification was last modified.
.RE
.RS
.TP
Access:
The date of the last "integrate" using this branch.
.RE
.RS
.TP
Description:
A short description of the branch (optional).
.RE
.RS
.TP
Options:
Flags to change the branch behavior.
.RE
.RS
.RS
.TP
locked
Allows only the branch owner to change its
specification. Prevents the branch from
being deleted.
.RE
.RE
.RS
.TP
View:
A mapping from the source files of the branch to the
target files of the branch. Both the left and right
hand sides of the mappings refer to the depot namespace.
See "p4 help views" for more on views.
.RE
.IP
New branches are created with a default view that maps all depot
files back into themselves. This view must be changed before the
branch view is usable.
.IP
A branch definition is used only by the "p4 integrate" command.
.IP
The -d flag deletes the named branch.
.IP
The -o flag causes the named branch specification to be written
to the standard output. The user"s editor is not invoked.
.IP
The -i flag causes a branch specification to be read from the
standard input. The user"s editor is not invoked.
.IP
The -f flag allows the superuser to delete any branch; normally
branches can only be deleted by their owner. -f also allows the
last modified date to be set.
.TP
.B p4 branches
.IP
Reports the list of all branches currently known to the system.
Branches takes no arguments.
.TP
.B p4 change [ -f -s ] [ changelist# ]
.TP
.B p4 change -d [ -f -s ] changelist#
.TP
.B p4 change -o [ -s ] [ changelist# ]
.TP
.B p4 change -i [ -f -s ]
.IP
"p4 change" creates and edits changelists and their descriptions.
With no argument, "p4 change" creates a new changelist. If a
changelist number is given, "p4 change" edits an existing, pending
changelist. In both cases the changelist specification is placed
into a form and the user"s editor is invoked.
.IP
The -d flag discards a pending changelist, but only if it has no
opened files and no pending fixes associated with it. Use "p4
opened -a" to report on opened files and "p4 reopen" to move them
to another changelist. Use "p4 fixes -c changelist#" to report on
pending fixes and "p4 fix -d -c changelist# jobs..." to delete
pending fixes. The changelist can only be deleted by the user and
client who created it, or by a superuser using the -f flag.
.IP
The -o flag causes the changelist specification to be written
to the standard output. The user"s editor is not invoked.
.IP
The -i flag causes a changelist specification to be read from the
standard input. The user"s editor is not invoked.
.IP
The -f flag allows the superuser to update or delete other users"
pending changelists. -f also allows the superuser to delete
submitted changelists once they have been emptied of files via
"p4 obliterate". Normally, submitted changelists are immutable.
.IP
The -s flag extends the list of jobs to include the fix status
for each job. On new changelists, the fix status begins as the
special status "ignore", which if left unchanged simply excludes
the job from those being fixed. Otherwise, the fix status, like
that applied with "p4 fix -s", becomes the job"s status when
the changelist is committed. Note that this option is not meant
for end-users. It exists to support propagating information from
an external defect tracking system.
.TP
.B p4 changes [ -i -l -m max -s status ] [ file[revRange] ... ]
.IP
Reports the list of all pending and submitted changelists currently
known to the system.
.IP
If files are specified, "p4 changes" limits its report to
changelists that affect those files. If the file specification
includes a revision range, "p4 changes" limits its report to
submitted changelists that affect those particular revisions.
See "p4 help revisions" for help specify revisions.
.IP
The -i flag also includes any changelists integrated into the
specified files.
.IP
The -l flag produces long output with the full text of the changelist
descriptions.
.IP
The -m max flag limits changes to the "max" most recent.
.IP
The -s status flag limits the output to pending or submitted
changelists.
.TP
.B p4 client [ -f -t template ] [ name ]
.TP
.B p4 client -d [ -f ] name
.TP
.B p4 client -o [ -t template ] [ name ]
.TP
.B p4 client -i [ -f ]
.IP
With no argument "p4 client" creates a new client view specification or
edits an existing client specification. The client name is taken
from the environment variable $P4CLIENT if set, or else from
the current host name. The specification form is put into a
temporary file and the editor (given by the environment variable
$P4EDITOR) is invoked. If a name is given, the specification of
the named client is displayed read-only.
.IP
The specification form contains the following fields:
.RS
.TP
Client:
The client name (read only.)
.RE
.RS
.TP
Host:
If set, restricts access to the named host.
If unset, access is allowed from any host.
.RE
.RS
.TP
Owner:
The user who created this client. Can be changed.
.RE
.RS
.TP
Update:
The date this specification was last modified.
.RE
.RS
.TP
Access:
The date this client was last used in any way.
.RE
.RS
.TP
Description:
A short description of the client (optional).
.RE
.RS
.TP
Root:
The root directory of the client file workspace
(given in local file system syntax), under which all
client files will be placed. If you change this, you
must physically relocate any files as well.
The special name "null" may be used to allow files
to be mapped to multiple drives on Windows clients.
.RE
.RS
.TP
Options:
Flags to change the client behavior. The defaults
are marked with *.
.RE
.RS
.RS
.TP
allwrite
.TP
noallwrite * 
Leaves all files writable on the client;
else only checked out files are writable.
.RE
.RE
.RS
.RS
.TP
clobber
.TP
noclobber * 
Allows "p4 sync" to overwrite writable
files on the client.
.RE
.RE
.RS
.RS
.TP
compress
.TP
nocompress * 
Compresses data sent between the client
and server to speed up slow connections.
.RE
.RE
.RS
.RS
.TP
locked
.TP
unlocked * 
Allows only the client owner to use the
client or change its specification.
Prevents the client from being deleted.
.RE
.RE
.RS
.RS
.TP
modtime
.TP
nomodtime * 
Causes "p4 sync" to preserve file
modification time from submitting client,
as with files with +m type modifier.
Otherwise modification time is left as
when the file was fetched.
.RE
.RE
.RS
.RS
.TP
rmdir
.TP
normdir *
Makes "p4 sync" attempt to delete a client
directory when all files are removed.
.RE
.RE
.IP
LineEnd: Set line ending character(s) for client text files.
.RS
.RS
.TP
local
Use mode native to the client (default).
.RE
.RE
.RS
.RS
.TP
unix
linefeed: UNIX style.
.RE
.RE
.RS
.RS
.TP
mac
carriage return: Macintosh style.
.RE
.RE
.RS
.RS
.TP
win
carriage return-linefeed: Windows style.
.RE
.RE
.RS
.RS
.TP
share
hybrid: writes UNIX style but reads UNIX or
Windows style.
.RE
.RE
.RS
.TP
View:
A mapping from the files in the depot to files in the
client workspace. This is the mechanism by which you
select what files you want on your client and where you
want them to be. The default view maps all depot files
onto the client. See "p4 help views" for view syntax.
A new view takes effect on the next "p4 sync".
.RE
.RS
.TP
Note:
changing the client root does not actually move the client
files; you must relocate them yourself. Similarly, changing
the "LineEnd" option does not actually update the client files;
you can refresh them with "p4 sync -f".
.RE
.IP
The -d flag causes the named client to be deleted, as long as it
has no opened files. The -f forces the delete
.IP
The -o flag causes the named client specification to be written
to the standard output. The user"s editor is not invoked.
.IP
The -i flag causes a client specification to be read from the
standard input. The user"s editor is not invoked.
.IP
The -t flag constructs the client"s view by copying the named
template client"s view, instead of using the existing view or
creating a new default view.
.IP
The -f flag allows the superuser to modify locked clients; normally
locked clients can only be modified by their owner. -f also allows
the last modified date to be set.
.TP
.B p4 clients
.IP
Reports the list of all clients currently known to the system.
.TP
.B p4 counter name
.TP
.B p4 counter [ -f ] name value
.TP
.B p4 counter -d name
.IP
The first form displays the value of the named counter.
.IP
The second form sets the counter to the given value. The -f flag
sets even those used by Perforce, as listed in "p4 help counters".
Moving the "change" counter backwards can have very bad results.
.IP
The third form deletes the counter. This usually has the same
effect as setting the counter to 0.
.IP
"p4 counter" requires "review" access granted by "p4 protect".
The -f flag require "super" access.
.TP
.B p4 counters
.IP
Reports the list of all counters in use by the server. There are
four counters the server uses directly:
.RS
.RS
.TP
change
the current change number
.RE
.RE
.RS
.RS
.TP
job
the current job number
.RE
.RE
.RS
.RS
.TP
journal
the current journal number
.RE
.RE
.RS
.RS
.TP
upgrade
the server database upgrade level
.RE
.RE
.IP
Other counters can be created by the "p4 counter" or "p4 review"
commands.
.TP
.B p4 delete [ -c changelist# ] file ...
.IP
Opens a file that currently exists in the depot for deletion.
If the file is present on the client it is removed. If a pending
changelist number is given with the -c flag the opened file is
associated with that changelist, otherwise it is associated with
the "default" pending changelist.
.IP
Files that are deleted generally do not appear on the have list.
.TP
.B p4 depot name
.TP
.B p4 depot -d name
.TP
.B p4 depot -o name
.TP
.B p4 depot -i
.IP
Create a new depot specification or edit an existing depot
specification. The specification form is put into a temporary
file and the editor (given by the environment variable $P4EDITOR)
is invoked.
.IP
The depot specification form contains the following fields:
.RS
.TP
Depot:
The name of the depot. This cannot conflict with
any branch, client, or label name.
.RE
.RS
.TP
Owner:
The user who created this depot.
.RE
.RS
.TP
Date:
The date this specification was last modified.
.RE
.RS
.TP
Description:
A short description of the depot (optional).
.RE
.RS
.TP
Type:
"local" or "remote". Normally depots are locally
managed by the server and occupy space in the server"s
root directory. A "remote" depot is a reference to
files in another Perforce server.
.RE
.RS
.TP
Address:
For remote depots, the $P4PORT (connection address)
of the remote server.
.RE
.RS
.TP
Map:
Path translation information, in the form of a file
pattern with a single ... in it. For local depots,
this path is relative to the server"s root directory
(e.g. depot/...). For remote depots, this path refers
to the remote server"s namespace (e.g. //depot/...).
.RE
.IP
The -d flag deletes the named depot. If any files exist in the
depot they must be removed first with "p4 obliterate".
.IP
The -o flag causes the named depot specification to be written
to the standard output. The user"s editor is not invoked.
.IP
The -i flag causes a depot specification to be read from the
standard input. The user"s editor is not invoked.
.TP
.B p4 depots
.IP
Reports the list of all depots created via the depot command.
Depots takes no arguments.
.TP
.B p4 describe [ -d<flag> -s ] changelist#
.IP
Display a changelist description, including the changelist number,
user, client, date of submission, textual description, list
of affected files and diffs of files updated. Pending changelists
are flagged as "pending" and the list of affected files and
file diffs is not displayed.
.IP
The -d<flag> passes a flag to the built-in diff routine to modify
the output: -dn (RCS), -dc (context), -ds (summary), -du (unified).
.IP
The -s flag requests a shortened form of describe that doesn"t
include the diffs of files updated.
.TP
.B p4 diff [ -d<flag> -f -sa -sd -se -sr -t ] [ file[rev] ... ]
.IP
Run diff (on the client) of a client file against the corresponding
revision in the depot. The file is only compared if the file is
opened for edit or the revision provided with the file argument is
not the same as the revision had by the client. See "p4 help
revisions" for help specifying revisions.
.IP
If no file argument is given, diff all open files.
This can be used to view pending changelists.
.IP
The -d<flag> passes a flag to the built-in diff routine to modify
the output: -dn (RCS), -dc (context), -ds (summary), -du (unified).
.IP
The -f flag forces a diff for every file, regardless of whether
they are opened or if the client has the named revision.
This can be used to verify the client contents.
.IP
The -s flag reduces the output of diff to the names of files
satisfying the following criteria:
.RS
.RS
.TP
-sa
Opened files that are different than the revision
in the depot, or missing.
.RE
.RE
.RS
.RS
.TP
-sd
Unopened files that are missing on the client.
.RE
.RE
.RS
.RS
.TP
-se
Unopened files that are different than the revision
in the depot.
.RE
.RE
.RS
.RS
.TP
-sr
Opened files that are the same as the revision in the
depot.
.RE
.RE
.IP
The -t flag forces "p4 diff" to diff even files with non-text
(binary) types.
.IP
If the environment variable $P4DIFF is set then the named program is
used rather than the implementation of diff included in the client.
The -d<flag>command can be used to pass arguments to the
external program. The -s flag is only implemented internally.
.TP
.B p4 diff2 [ -d<flag> -q -t ] file1 file2
.TP
.B p4 diff2 [ -d<flag> -q -t ] -b branch [ [ file1 ] file2 ]
.IP
Run diff (on the server) of two files in the depot. Both files
may optionally include a revision specification; the default is
to compare the head revision. See "p4 help revisions" for help
specifying revisions. Wildcards may be used, but they must
match between file1 and file2.
.IP
Diff2 introduces each diff with a header line of the form
.IP
==== file1 (type1) - file2 (type2) ==== summary
.IP
file1 or file2 may be "<none>", meaning that only one of the
matched files actually exists at the given revision. The
summary is one of: "identical" - file contents are identical and
types are the same, "types" - file contents are identical but
the types are different, and "content" - file contents are
different.
.IP
The -b flag causes diff2 to use the branch view to specify the
pairs of files to compare. If file arguments are also present, they
can further limit the files and specify the revisions for comparison.
Note that if only one file is given, it restricts the right-hand
side of the branch view.
.IP
The -d<flag> passes a flag to the built-in diff routine to modify
the output: -dn (RCS), -dc (context), -ds (summary), -du (unified).
.IP
The -q suppresses the display of the header lines of files whose
content and types are identical and suppresses the actual diff
for all files.
.IP
The -t flag forces "p4 diff2" to diff even files with non-text
(binary) types.
.TP
.B p4 dirs [ -C -D -H ] dir[revRange] ...
.IP
List any directories matching the file pattern dir. Because of
implementation details, "p4 dirs" does not allow the ... wildcard.
Use the * wildcard instead.
.IP
Perforce does not track directories per se, but instead considers
a path a directory if there are any undeleted files with that path
as a prefix.
.IP
If the dir argument includes a revision range, then only directories
with files of those revisions are listed. Normally directories with
any files are listed. See "p4 help revisions" for help specifying
revisions.
.IP
The -C flag limits the output to directories that are mapped on
the current client.
.IP
The -D includes directories with only deleted files.
.IP
The -H flag lists directories of files on the "have" list.
.TP
.B p4 edit [ -c changelist# ] [ -t filetype ] file ...
.IP
Open an existing file for edit. The server notes that the current
user on the current client has the file opened, and then changes
the file permission from read-only to read/write.
.IP
If -c changelist# is given, the file is put into the pending
changelist; the changelist must have been previously created by
"p4 change". Otherwise the file is opened in the "default"
(unnumbered) changelist.
.IP
If -t filetype is given the file is explicitly opened as that
filetype. Otherwise, the type of the previous revision is reused.
See "p4 help filetypes" for a complete list.
.TP
.B p4 filelog [ -i -l -m maxRevs ] file ...
.IP
List the revision history of the files named, working backwards
from the latest revision to the first.
.IP
The -i flag follows branches. If a file was created by branching,
"p4 filelog" also lists the revisions of the source file, but
only those revisions leading up to the branch point.
.IP
The -l flag produces long output with the full text of the
changelist descriptions.
.IP
The -m maxRevs displays at most "maxRevs" revisions per file.
.TP
.B p4 files file[revRange] ...
.IP
List files named or matching wild card specification. Display
shows depot file name, revision, file type, change action and
changelist number of the current head revision. If client file
names are given as arguments the view mapping is used to list the
corresponding depot files.
.IP
If the file argument has a revision, then all files as of that
revision are listed. If the file argument has a revision range,
then only files selected by that revision range are listed, and
the highest revision in the range is used for each file. Normally,
the head revision is listed. See "p4 help revisions" for help
specifying revisions.
.TP
.B p4 fix [ -d ] [ -s status ] -c changelist# jobName ...
.IP
"p4 fix" marks each named job as being fixed by the changelist
number given with -c. The changelist may be either pending or,
submitted and the jobs may be still be opened or already closed
(fixed by another changelist).
.IP
If the changelist has already been submitted and the job is still
open then "p4 fix" marks the job closed. If the changelist has not
been submitted and the job is still open, the job will be marked
closed when the changelist is submitted. If the job is already
closed, it is left alone.
.IP
The -d flag causes the specified fixes to be deleted. This does not
otherwise affect the named changelist or jobs.
.IP
The -s uses the given status instead of the default "closed". This
status is reported by "p4 fixes" and also reflected in the job"s
status (immediately if the changelist is committed; on submission
if the changelist is pending).
.TP
.B p4 fixes [ -i ] [ -j jobName ] [ -c changelist# ] [ file[revRange] ... ]
.IP
"p4 fixes" shows all jobs with fix records associated with them,
along with the changelist number of the fix. Fix records are
created either directly with the "p4 fix" command or via changelist
creation with the "p4 change" and "p4 submit" commands.
.IP
The "p4 fixes" command show fixes regardless of whether the
changelists are submitted or still pending.
.IP
By default, "p4 fixes" lists all fixes. This list can be limited
in any of three ways. If -j jobName is given, only fixes for the
named job are listed. If -c changelist# is given, only fixes from
the numbered changelist are listed. If a file (pattern) is given,
only fixes for submitted changelists affecting that file (or set of
files) are listed. The file pattern may include wildcards and/or a
revision number range. See "p4 help revisions" for help specifying
revisions.
.IP
The -i flag also includes any fixes made by changelists integrated
into the specified files.
.TP
.B p4 flush [ -f -n ] [ file[revRange] ... ]
.IP
"p4 flush" is a variant of "p4 sync" that bypasses the client file
update. It can be used to make the server believe that a client
workspace already has a file.
.IP
Because "p4 flush" doesn"t move files, it works especially quickly.
As its purpose is to correct the Perforce server when it is wrong
about what files are on the client, use of "p4 flush" can confuse
the server if you are wrong about the client"s contents.
.IP
"p4 flush" takes the same flags as "p4 sync".
.TP
.B p4 fstat [ -c changelist# ] [ -C -l -H -P -s -W ] file[rev] ...
.IP
Fstat is intended for programmatic interfaces into Perforce. It
dumps information about each file, with each item of information on
a separate line. Fstat is best used within a Perforce API application
where the items can be accessed as variables, but its output is also
suitable for parsing from the client command output.
.IP
The fields that fstat displays are:
.RS
.RS
.TP
clientFile
-- local path
.RE
.RE
.RS
.RS
.TP
depotFile
-- name in depot
.RE
.RE
.RS
.RS
.TP
headAction
-- action at head rev, if in depot
.RE
.RE
.RS
.RS
.TP
headChange
-- head rev changelist#, if in depot
.RE
.RE
.RS
.RS
.TP
headRev
-- head rev #, if in depot
.RE
.RE
.RS
.RS
.TP
headType
-- head rev type, if in depot
.RE
.RE
.RS
.RS
.TP
headTime
-- head rev mod time, if in depot
.RE
.RE
.RS
.RS
.TP
haveRev
-- rev had on client, if on client
.RE
.RE
.RS
.RS
.TP
action
-- open action, if opened
.RE
.RE
.RS
.RS
.TP
change
-- open changelist#, if opened
.RE
.RE
.RS
.RS
.TP
unresolved
-- unresolved integration records
.RE
.RE
.RS
.RS
.TP
otherOpen
-- set if someone else has it open
.RE
.RE
.RS
.RS
.TP
otherLock
-- set if someone else has it locked
.RE
.RE
.RS
.RS
.TP
ourLock
-- set if this user/client has it locked
.RE
.RE
.IP
The -c changelist# flag instructs fstat to display only files
affected since the given changelist number. This operation is
much faster than using a revision range on the affected files.
.IP
The -C, -H, and -W flags limits the output to files that are
mapped, synced, and opened (respectively) on the current client.
.IP
The -P flag outputs the clientFile in Perforce syntax (//client/).
Normally, clientFile is in local host syntax.
.IP
The -l includes a fileSize field (which may be expensive to compute).
.IP
The -s flag shortens the output by excluding client related data
about the file.
.TP
.B p4 group name
.TP
.B p4 group -d name
.TP
.B p4 group -o name
.TP
.B p4 group -i
.IP
Create a new user group or add/delete members from an existing
group. A group"s members can be users and/or other groups.
The group specification form is put into a temporary file and
the editor (given by the environment variable $P4EDITOR) is invoked.
.IP
A group exists when it has any users or other groups in it, and
ceases to exist if all users and groups in it are removed.
.IP
Each group has a MaxResults field, which limits the data size for
operations that the users in that group can perform. If MaxResults
is "unlimited", no limit is imposed. A user"s MaxResults is the
highest of any group with a limit to which he belongs. If the
user belongs to no group with a limit, then his MaxResults is
unlimited. See "p4 help maxresults" for more information.
.IP
The -d flag deletes all users and groups from the named group, thus
deleting the whole group.
.IP
The -o flag causes the named group specification to be written
to the standard output. The user"s editor is not invoked.
.IP
The -i flag causes a group specification to be read from the
standard input. The user"s editor is not invoked. The new
group specification entirely replaces the previous.
.IP
All commands that require access granted by "p4 protect" consider
a user"s groups when calculating access levels. Groups are also
used to calculate a user"s MaxResults.
.IP
"p4 group" requires superuser access granted by "p4 protect".
.TP
.B p4 groups [ user ]
.IP
Displays the list of all groups of users created by the
"p4 group" command. If a user argument is given, only groups
with that user are displayed.
.TP
.B p4 have [ file ... ]
.IP
depot-file#revision - client-file
.TP
.B p4 help [ command ... ]
.IP
Print a help message about command. If no command name is given
print a general help message about Perforce and give a list
of available client commands.
.TP
.B p4 info
.IP
Info dumps out what the server knows about the client (the user
name, the client name, and the client directory) and some server
information (the server"s address, date, version, and license data).
.TP
.B p4 integrate [ options ] fromFile[revRange] toFile
.TP
.B p4 integrate [ options ] -b branch [ toFile[revRange] ... ]
.TP
.B p4 integrate [ options ] -b branch -s fromFile[revRange] [ toFile ... ]
.RS
.TP
options:
-c changelist# -d -f -i -n -r -t -v
.RE
.IP
Integrate attempts to propagate changes between two sets of files:
from the source files of the branch view to the target files of the
branch view. The result is target files that are opened for the
action reflecting changes made in the corresponding source files.
The actions are either "branch" (for new files), "delete" (when the
source file was deleted), or "integrate" (when the source file was
changed). In all cases, the opened files must be submitted with
"p4 submit" before the integration is reflected in the depot.
.IP
Files opened for "branch" or "integrate" are left read-only on the
client. For "integrate", a subsequent "p4 resolve" command handles
the actual merging. If merging takes more than one editing session,
"p4 resolve -f" can be used to revisit a merge. In this normal case
a later "p4 integrate -r" knows that the results of the merge don"t
need to be merged back.
.IP
You can downgrade a file opened for "integrate" or "branch" to
"edit" or "add" and gain write permission by reopening the file
with the "p4 edit" command. Downgrading causes any later
"p4 integrate -r" to want to merge the changes back into the
source file.
.IP
A branch view may be given directly on the command line by stating
the source (from) and target (to) files, or indirectly by naming
a stored branch view with -b branch. A stored branch view may have
many mappings, while a view on the command line can only have one.
If a stored branch view is given, the target files and source
files and revisions may be further limited on the command.
.IP
If no file specification is given then the entire branch view is
examined for needed integrations. If a file specification is
given, the integration is limited to only those target files.
In both cases, the integration is also limited to those target
files that are also in the client view.
.IP
If no revision specification is given then all revisions of the
source file are considered for integration. If a single revision
is given, then only revisions up to the given revision are included.
If a pair of revisions is given (separated by a comma (,)) then
only those revisions, inclusively, are integrated. Note that the
revision specification concerns the fromFile, but is attached to
the toFile. See "p4 help revisions" for help specifying revisions.
.IP
The -f flag forces integrate to act without regard for previous
integration history. Normally, integrate skips any file revisions
already integrated. Note: unless revRange is given as well, the -f
flag will force "p4 resolve" perform merges without a common base.
To avoid this, use -f only to force integration of specific changes.
-f implies -i (below).
.IP
If -c changelist# is given, the files are opened in the numbered
pending changelist instead of the "default" changelist.
.IP
The -d flag enables integrations around deleted revisions. If the
target file has been deleted and the source file has changed, -d
will re-branch the source file on top of the target file. If the
source file has been deleted and the target file has changed, -d
will delete the target file. Without -d, it refuses to mix
outstanding edits with a deleted file.
.IP
The -i flag enables baseless merges. When integrating into an
existing target file, "p4 integrate" selects which revision "p4
resolve" uses as the base for its merge. That revision should be
the revision of the source file just before the first revision being
integrated. But if the first revision being integrated is the
revision at which the source file was added, which can happen if
there were no prior integrations between the source and target
files, then "p4 integrate" refuses the baseless merge. The -i flag
forces "p4 integrate" to schedule the merge, and "p4 resolve" then
uses the first, added revision as the base.
.IP
The -n flag displays what integrations would be necessary but does
not schedule them.
.IP
The -r flag reverses the mappings in the branch view, with the
target files and source files exchanging place. The -b branch flag
is required.
.IP
The -s fromFile[revRange] flag specifies the source (from) file.
It is used with the -b branch flag to limit the integrate to just
those selected source files. The integration is still limited to
any stated target (to) files on the command line. The -s flag also
causes the branch view to work bidirectionally, using the union of
the mappings and the reversed mappings. When the -s flag is used
the source revision range is attached to the source file, rather than
to the target files. Yes, this is confusing to code, too.
.IP
The -t flag makes the source file"s filetype propagate to the target
file. Normally, the target file retain its previous filetype.
Newly branched files always use the source file"s filetype. The
filetype can still be changed before "p4 submit" with "p4 reopen".
.IP
The -v flag makes "p4 integrate" work faster by not copying newly
branched files to the client. In this case, the files can be
fetched with "p4 sync" after they are submitted with "submit".
[Note that this was the default behavior for newly branched files
in release 97.2 and earlier.]
.RS
.TP
Note:
the syntax "p4 integrate -b branch toFile[revRange]" is
provided for backwards compatibility, but is confusing because
it mixes the target file with the source revisions.
.RE
.TP
.B p4 integrated file ...
.IP
Integrated shows integrations that have already been submitted.
Use "p4 resolve -n" to see unresolved integrations and "p4 resolved"
to see resolved but unsubmitted integrations.
.TP
.B p4 job [ -f ] [ jobName ]
.TP
.B p4 job -d jobName
.TP
.B p4 job -o [ jobName ]
.TP
.B p4 job -i [ -f ]
.IP
"p4 job" creates and edits job specifications using an ASCII form.
A job is a defect, enhancement, or other unit of intended work.
The "p4 fix" command can associate changelists with jobs.
.IP
With no arguments, "p4 job" creates a blank job specification form
and invokes the user"s editor. When the form is saved, a job name
of the form jobNNNNNN is created. If a jobName is given on the
command line either that named job will be created or, if the job
already exists, the job can be modified.
.IP
As jobs are entered or updated, all fields are indexed for
searching by "p4 jobs". Text fields are broken into individual
alphanumeric words (punctuation and whitespace are ignored) and
each word is entered, case folded, into the word index. Date
fields are converted to an internal representation (seconds
since 1970/01/01 00:00:00) and entered into the date index.
.IP
The fields of a job are defined by the "p4 jobspec" command.
There is a simple default jobspec that is used if no explicit
one has been defined.
.IP
The -d flag deletes the named job and any associated fixes.
.IP
The -o flag causes the named job specification to be written
to the standard output. The user"s editor is not invoked.
.IP
The -i flag causes a job specification to be read from the
standard input. The user"s editor is not invoked.
.IP
The -f flag allows otherwise read-only fields to be set.
.TP
.B p4 jobs [ -e jobview -i -l -m max -r ] [ file[revRange] ... ]
.TP
.B p4 jobs -R
.IP
Reports the list of all jobs currently known to the system. If
a file (pattern) is given, only fixes for submitted changelists
affecting that file (or set of files) are listed. The file pattern
may include wildcards and/or a revision number range. See "p4 help
revisions" for help specifying revisions.
.IP
The -e jobview limits the output to jobs satisfying the expression
given as "jobview". See "p4 help jobview" for a description of
jobview syntax.
.IP
The -i flag also includes any fixes made by changelists integrated
into the specified files.
.IP
The -l flag produces long output with the full text of the job
descriptions.
.IP
The -m max flag limits the output to the first "max" jobs,
ordered by their job name.
.IP
The -r flag sorts the jobs in reverse order (by job name).
.IP
The -R flag rebuilds the jobs table and reindexes each job; this
is necessary after upgrading to 98.2. "p4 jobs -R" requires
superuser access granted by "p4 protect".
.TP
.B p4 jobspec
.TP
.B p4 jobspec -o
.TP
.B p4 jobspec -i
.IP
Jobspec edits the template that specifies the format of jobs.
This format is used by "p4 job" when jobs are entered or updated,
and by "p4 jobs" and "p4 describe" when jobs are displayed.
.IP
Jobspec brings up a form with the following fields:
.RS
.TP
Fields:
A list of the fields maintained for each job, one
line per field. Each line has five words: code, name,
data-type, len, and field-type.
.RE
"code" is a unique integer identifier for storing
the data of the field. Job codes must be between
101 and 199.
"name" is the name of the field for the job.
"data-type" indicates the format of the field:
.IP
word: a single word (any value)
date: a date/time field
select: one of a set of words
line: a one-liner
text: a block of text
"len" is the recommended character length of a
display box for the field. If 0, a text box is
assumed.
"field-type" indicates how to handle the setting of
the field:
.IP
optional: no default, and not required to be present
default: default provided, still not required
required: default provided, value must be present
once: set once to the default and never changed
always: always reset to the default upon saving
.RS
.TP
Values:
A list of "select" fields and the values those fields
can have. Each line has two words: the field name and
the values list, with individual values separated by
"/" (no spaces).
.RE
.RS
.TP
Presets:
A list of fields and their default values, for fields
whose "setting" flag is other than "optional". Each
line has two words: the field name and the default
value. If the value has spaces, it must be enclosed
in double quotes. The following special defaults are
recognized:
.RE
.IP
$user: the user entering the job
$now: the current date
$blank: the words "<enter description here>"
.RS
.TP
Comments:
textual comments to be included at the top of each
job specification, to help the user fill out the form.
Each line must begin with the comment character "#".
.RE
.IP
Certain field codes have special significance:
.IP
code 101, required: the job name
code 102, optional: the job status
code 103, optional: the user who created the job
code 104, optional: the date the job was created
code 105, optional: the description
.IP
If there is a job status field (102), "p4 submit" and "p4 fix"
will set it to "closed" for any jobs being fixed by the change.
.IP
Fields 102-105 are used by "p4 describe" and "p4 jobs" to
display a job summary. Any missing fields simply will not
appear in the summary line.
.IP
If field 105 is present, it is assumed to be a description,
which is used by "p4 change" and "p4 submit" to annotate the
list of jobs to be fixed by the change being created.
.IP
When updating the jobspec after jobs have been entered, certain
limitations apply:
.IP
Data is stored according to its code. Fields can be renamed
by keeping the same code. Removing a code can abandon the
associated data stored for the code.
.IP
Changing the definition of a code (e.g. from "text" to "word")
can require users to bring jobs into the new format as they
are edited.
.IP
The -o flag causes the job template to be written to the standard
output. The user"s editor is not invoked.
.IP
The -i flag causes a job template to be read from the standard
input. The user"s editor is not invoked.
.IP
"p4 jobspec" requires superuser access granted by "p4 protect".
.TP
.B p4 label [ -f -t template ] name
.TP
.B p4 label -d [ -f ] name
.TP
.B p4 label -o [ -t template ] name
.TP
.B p4 label -i [ -f ]
.IP
Create a new label specification or edit an existing label
specification. A name is required. The specification form
is put into a temporary file and the editor (given by the
environment variable $P4EDITOR) is invoked.
.IP
The label specification form contains the following fields:
.RS
.TP
Label:
The label name (read only.)
.RE
.RS
.TP
Owner:
The user who created this label. Can be changed.
.RE
.RS
.TP
Update:
The date this specification was last modified.
.RE
.RS
.TP
Access:
The date of the last "labelsync" or use of "@label"
on this label.
.RE
.RS
.TP
Description:
A short description of the label (optional).
.RE
.RS
.TP
Options:
Flags to change the label behavior.
.RE
.RS
.RS
.TP
locked
Allows only the label owner to change its
specification. Prevents the label from
being deleted. Prohibits "p4 labelsync".
.RE
.RE
.RS
.TP
View:
A mapping to select files from the depot.
The default view selects all depot files.
.RE
.IP
A label definition is used only by the "p4 labelsync" command.
Only the owner of a label may run labelsync on that label.
A label that has its Options: set to "locked" cannot be updated.
.IP
Flag -d causes the named label to be deleted, as long as it is
not locked. The -f flag forces the delete.
.IP
The -o flag causes the named label specification to be written
to the standard output. The user"s editor is not invoked.
.IP
The -i flag causes a label specification to be read from the
standard input. The user"s editor is not invoked.
.IP
The -t flag constructs the label"s view by copying the named
template label"s view, instead of using the existing view or
creating a new default view.
.IP
The -f flag allows the superuser to delete any label; normally
locked labels can only be deleted by their owner. -f also allows
the last modified date to be set.
.TP
.B p4 labels [ file[revrange] ]
.IP
Reports the list of all labels currently known to the system.
.IP
If files are specified, "p4 labels" limits its report to labels
that contain those files. If the file specification includes
a revision range, "p4 labels" limits its report to labels that
contain those particular revisions. See "p4 help revisions"
for help specify revisions.
.TP
.B p4 labelsync [ -a -d -n ] -l label [ file[revRange] ... ]
.IP
Labelsync causes the named label to reflect the current contents
of the client. It records the last revision of each file taken
onto the client. The label"s name can subsequently be used in
a revision specification as @label to refer to the revision of
a file as stored in the label.
.IP
Without a file argument, labelsync causes the label to reflect the
contents of the whole client, by adding, deleting, and updating the
label. If a file is given, labelsync updates only that named file.
.IP
If the file argument includes a revision specification, then that
revision is used instead of the revision taken by the client.
See "p4 help revisions" for help specifying revisions.
.IP
If the file argument includes a revision range specification, then
only files selected by the revision range are updated, and the
highest revision in the range is used.
.IP
The -a flag causes labelsync to add the named file to the label;
no files will be deleted from the label.
.IP
The -d deletes the named file from the label, regardless of revision.
.IP
The -n flag lists how the label would be affected, but doesn"t
actually update the label.
.IP
Only the owner of a label may run labelsync on that label.
A label that has its Options: set to "locked" cannot be updated.
.TP
.B p4 lock [ -c changelist# ] [ file ... ]
.IP
The open files named are locked in the depot, preventing any
user other than the current user on the current client from
submitting changes to the files. If a file is already locked
then the lock request is rejected. If no file names are given
then lock all files currently open in the changelist number given
or in the "default" changelist if no changelist number is given.
.TP
.B p4 logger [ -c sequence# ] [ -t counter ]
.IP
Dumps the event log, which notes updates to changes and jobs, for
use with defect tracking integration. The event log is enabled
by setting the counter "logger" (to 0) with "p4 counter". Each
event has a sequence number. The presence of an entry in the log
doesn"t guarantee that the named entity has changed.
.IP
If a sequence# is given with -c, only events since that number are
listed. If a counter is given with -t, only events since the
number of that counter are listed. If both are given, then the
counter is updated to the sequence number and nothing is output.
If the update brings the counter to the highest sequence number
in the log, the log is cleared. This generally means that only
one user can really make use of this option.
.IP
"p4 logger" is not meant as an end-user command. It exists to
support propagating information to an external defect tracking
system.
.IP
"p4 logger -c" requires "review" access granted by "p4 protect".
.TP
.B p4 obliterate [ -y -z ] file[revRange] ...
.IP
Obliterate removes files and their history from the server in a
way that they won"t come back. (See "p4 delete" for the non-
destructive way to delete a file.) It retrieves space used by those
files in the archive and then clears the files from all lists
maintained by the server. Files in client workspaces are not
affected, except that Perforce will no longer recognize them
as being under its control.
.IP
Obliterate carefully undoes the lazy copies made when "p4 integrate"
creates a branch. Because of this, it is possible that obliterating
files will not recover any space.
.IP
If the file argument has a revision, then only that revision is
obliterated. If the file argument has a revision range, then only
the revisions in that range are obliterated. See "p4 help revisions"
for help.
.IP
The -y flag instruct obliterate to do its work. Otherwise, it
just displays what it would do.
.IP
The -z flag restricts obliterate to undoing lazy copies. It does
not actually remove any files or metadata, but creates physical
copies of previously lazy copies, and as such, is likely to increase
space use on the server. Use this on the source files to ensure that
in the database no other files refer to the named files.
.IP
"p4 obliterate" requires superuser access granted by "p4 protect".
.TP
.B p4 opened [ -a -c changelist# ] [ file ... ]
.IP
Shows files currently opened for pending changelists or indicates
for the specified individual files whether they are currently opened.
If no file names are given, all files open on the current client
are listed.
.IP
The -a flag lists opened files in all clients. Normally only files
opened by the current client are listed.
.IP
The -c changelist# flag restricts the list to files opened under
the given changelist#. Normally files in any changelist (include the
"default") are listed.
.TP
.B p4 passwd [ -O oldPassword -P newPassword ] [ user ]
.IP
"p4 passwd" sets the user"s password on the server.
.IP
Once a password is set for a user on the server, then in order for
that user to invoke any Perforce client commands the same password
must be set on the client in the environment variable $P4PASSWD.
(On Windows, "p4 passwd" sets this as well.)
.IP
"p4 passwd" prompts for both the old password and the new password
with character echoing turned off. Setting the password to an
empty string deletes the password.
.IP
The -O flag provides the old password, avoiding prompting.
.IP
The -P flag provides the new password, avoiding prompting.
.IP
Setting the password of someone other than the current user
requires superuser access granted by "p4 protect". In this case
"p4 passwd" does not prompt for the old password.
.TP
.B p4 print [ -o localFile -q ] file[revRange] ...
.IP
Retrieve the contents of a depot file to the client"s standard
output. The client"s have list is not affected. If file is
specified as a client file name, the client view is used to
find the corresponding depot file.
.IP
If the file argument has a revision, then all files as of that
revision are printed. If the file argument has a revision range,
then only files selected by that revision range are printed, and
the highest revision in the range is used for each file. Normally,
the head revision is printed. See "p4 help revisions" for help
specifying revisions.
.IP
The -o localFile flag redirects the output to the named file on
the client filesystem. In this case, at most one file is written.
.IP
The -q flag suppresses the initial line that displays the file name
and revision.
.TP
.B p4 protect
.TP
.B p4 protect -o
.TP
.B p4 protect -i
.IP
"p4 protect" edits the protections table using an ASCII form.
Once protections are in place, only a user with superuser access
may use the "p4 protect" command.
.IP
Each line contains a protection mode, a group/user indicator, the
group/user name, client host id and a depot file path pattern.
A user gets the highest privilege granted on any line.
.RS
.TP
Note:
remote depot accesses are made using the pseudo-user "remote";
access by other servers can be controlled by granting appropriate
permissions to the "remote" user.
.RE
.RS
.TP
Mode:
The permission being granted. Each permission includes
all the permissions above it, except for "review".
.RE
list - users can see names but not contents of files;
users can see all non-file related metadata
(clients, users, changelists, jobs, etc.)
read - users can sync, diff, and print files
open - users can add, edit, delete, and integrate files
write - users can submit open files
super - allows access to the "p4 protect" command
review - allows access to the "p4 review" command;
implies read access
.IP
Group/User indicator: either "group" or "user".
.RS
.TP
Name:
A Perforce group or user name; may be wildcarded.
.RE
.RS
.TP
Host:
The IP address of a client host; may be wildcarded.
.RE
.RS
.TP
Path:
The part of the depot being granted access.
.RE
.IP
The -o flag causes the protection table to be written
to the standard output. The user"s editor is not invoked.
.IP
The -i flag causes the protection table to be read from the
standard input. The user"s editor is not invoked.
.TP
.B p4 integrate from to
.TP
.B p4 delete from
.TP
.B p4 submit
.IP
Perforce does not support a single "rename" command, but files can
be renamed by branching one file into another and then deleting the
original file.
.IP
The "from" and "to" file arguments may include wildcards as long as
they are matched.
.IP
Integrating from files require read access to the files, but deleting
them requires write access.
.IP
For further information, see the help for the individual commands.
.TP
.B p4 reopen [ -c changelist# ] [ -t filetype ] file ...
.IP
Reopen takes an already opened file and reopens it for the current
user, optionally changing its changelist or filetype.
.IP
The changelist must have previously been created with "p4 change"
or may be the "default" changelist.
.IP
See "p4 help filetypes" for a list of types.
.TP
.B p4 resolve [ -af -am -as -at -ay -f -n -t -v ] [ file ... ]
.IP
Resolve handles file integrations through an interactive dialog.
If no file is named all open files requiring integration will
be acted upon.
.IP
Perforce detects the occurrence of parallel changes, requiring
a merger of changes and resolution of potential conflicts.
Resolution may be either textual or non-textual.
Textual resolution occurs when there are parallel edits to
related text files. In this case it may be possible to comingle
edits meaningfully. Non-textual resolution occurs when at least
one of the related files is binary, or the change actions
themselves are incompatible, such as when one file has been
deleted while the other file has been edited.
.IP
For textual resolution you are provided with a file containing a
merger of your changes in the working file on the client
("yours") with the parallel changes that have been made
in the depot ("theirs"), based on a common original ancestor
revision of the two parallel versions ("base").
.IP
The display presents a count of change sections of the merged
text according to whether they are:
.IP
yours change is only in your working revision (no conflict)
theirs change is only in the depot revision (no conflict)
both same text added or changed in both (no conflict)
conflicting conflicting changes between the yours and theirs
.IP
If the count for "conflicts" is non-zero then the merged
version will contain integration marks bracketing alternative
changes at places in the text where conflicts occur. You
must edit the file to resolve the conflict and remove the
integration marks.
.IP
For non-textual resolution no merge file is created and you are given
the choice of choosing "yours" or "theirs".
.IP
Choices for action include:
.RS
.TP
Accept:

at Keep only changes to their file.
ay Keep only changes to your file.
* am Keep merged file.
* a Keep autoselected file.
.RE
.RS
.TP
Diff:

* dt See their changes alone.
* dy See your changes alone.
* dm See merged changes.
d Diff your file against merged file.
.RE
.RS
.TP
Edit:

et Edit their file (read only).
ey Edit your file (read/write).
* e Edit merged file (read/write).
.RE
.RS
.TP
Misc:

* m Run "$P4MERGE base theirs yours merged".
s Skip this file.
h Print this help message.
^C Quit the resolve operation.
.RE
.IP
Options marked (*) appear only for textual resolution.
.IP
Any form of Accept marks the resolution complete (to the users
satisfaction). Skip leaves the integration marked unresolved
allowing you to return to it at a later time.
.IP
The Merge option allows you to invoke your own integration and
conflict resolution utility (named in the $P4MERGE environment
variable). This utility is expected to replace the existing
merged file with a new one.
.IP
The -am flag puts "p4 resolve" into automatic mode: if there are
conflicts, the file is skipped; if there are no conflicts and
yours hasn"t changed it accepts theirs; if theirs hasn"t changed
it accepts yours; if both yours and theirs have changed it accepts
the merge. Files that have no base for merging (e.g. binary files)
are always skipped.
.IP
The -af flag forces "p4 resolve" in automatic mode to accept the
merged file even if there are conflicts.
.IP
The -as flag performs a "safe" automatic resolve, accepting only
files that have either your changes or their changes, but not both.
Files with changes to both yours and theirs are skipped.
.IP
The -at and -ay flags perform an automatic resolve that skips the
merging. Instead it automatically accepts their (-at) or your (-ay)
version of the file. The -at flag should be used with care, as
it overwrites any changes made to the file in the client workspace.
.IP
The -f flag allows previously resolved files to be resolved again.
Normally, once files have been resolved then "p4 resolve" won"t
display them again. This is the proper way to re-edit files if the
results of an initial "p4 resolve" are not satisfactory.
.IP
The -n flag lists the integrations which would be performed
without actually putting the user into the resolution dialog.
.IP
The -t flag forces "p4 resolve" to attempt a textual merge, even
for files with non-text (binary) types.
.IP
The -v flag causes "p4 resolve" to put in markers for all changes,
not just those in conflict. The markers must be edited out before
the merged file can be accepted.
.TP
.B p4 resolved [ file ... ]
.IP
Resolved shows integrations that have already been resolved
but not yet submitted. Use "p4 resolve -n" to see unresolved
integrations and "p4 integrated" to see already submitted
integrations.
.TP
.B p4 revert [ -a -c changelist# ] file ...
.IP
Revert an open file back to the revision previously synced from
the depot, discarding any pending changelists or integrations that
have been made. This command requires naming files explicitly.
After running revert the named files will no longer be locked
or open.
.IP
The -a flag tells "p4 revert" to revert only those files which
are opened for edit or integrate and are unchanged or missing.
Files with pending integration records are left open. With the
-a flag, the file arguments are optional.
.IP
The -c flag limits "p4 revert" to files opened under the given,
pending changelist.
.TP
.B p4 review [ -c changelist# ] [ -t counter ]
.IP
"p4 review" lists changelists that have not been reviewed before,
as tracked by the named counter. If the counter is not given,
"p4 review" lists all changelists. (If a changelist# and counter
are given, "p4 review" sets the counter to that changelist# and
produces no output. This functionality has been superceded by the
"p4 counter" command.)
.IP
"p4 review" is not meant as an end-user command. It exists to
support an automated change review daemon.
.TP
.B p4 reviews [ -c changelist# ] [ file ... ]
.IP
"p4 reviews" lists all users who have subscribed to review the named
files, the files in the numbered changelist, or all files by default.
Users subscribe to review files via the "p4 user" command.
.TP
.B p4 set [ -s -S service ] [ var=[value] ]
.IP
"p4 set" sets the registry variables used by Perforce on Windows
platforms. Normally, the variable "var" is set to "value".
If "value" is missing, the variable "var" is unset. Without
any arguments at all, "p4 set" list variable settings.
.IP
The -s flag causes "p4 set" to set variables for the whole system
rather than for the user. You must have NT administrator powers
to use this.
.IP
The -S service flag causes "p4 set" to set variables for the named
service. You must have NT administrator powers to use this.
.IP
Currently, registry variable entries may be overridden by environment
variables and (in some cases) flags on the command line.
See "p4 help environment" for a list of environment/registry variables.
.TP
.B p4 submit [ -s ]
.TP
.B p4 submit [ -s ] files
.TP
.B p4 submit -c changelist#
.TP
.B p4 submit -i [ -s ]
.IP
"p4 submit" commits a pending changelist and its files to the depot.
.IP
With no argument "p4 submit" attempts to submit all files in the
"default" changelist. Submit provides the user with a dialog
similar to "p4 change" so the user can compose a changelist
description. In this dialog the user is presented with the list
of files open in changelist "default". Files may be deleted from
this list but they cannot be added. (Use an open command (edit,
add, delete) to add additional files to a changelist.)
.IP
If a (single) file pattern is given, only those files in
the "default" changelist that match the pattern will be submitted.
.IP
The -c flag submits the numbered pending changelist that has been
previously created with "p4 change" or a failed "p4 submit".
.IP
The -i flag causes a changelist specification (including files to be
submitted) to be read from the standard input. The user"s editor
is not invoked.
.IP
The -s flag extends the list of jobs to include the fix status
for each job, which becomes the job"s status when the changelist
is committed. See "p4 help change" for more notes on this option.
.IP
Before committing a changelist submit locks all associated files not
already locked. If any file cannot be locked, or if the submit
fails for any other reason the files are left open in a newly
created pending changelist.
.IP
Submit is guaranteed to be atomic. Either all files will be
updated in the depot as a unit or none will be.
.TP
.B p4 sync [ -f -n ] [ file[revRange] ... ]
.IP
Sync updates the client workspace to reflect its current view (if
it has changed) and the current contents of the depot (if it has
changed). The client view is used to map client file names to
depot file names and vice versa.
.IP
Sync adds files that are in the client view but which have not been
retrieved before. Sync deletes previously retrieved files which
are no longer in the client view or have been deleted from the
depot. Sync updates files which are still in the client view and
which have been updated in the depot.
.IP
Normally, sync affects all files in the client workspace. If file
arguments are given, sync limits its operation to those files.
The file arguments may contain wildcards.
.IP
If the file argument includes a revision specifier, then the given
revision is retrieved. Normally, the head revision is retrieved.
See "p4 help revisions" for help specifying revisions.
.IP
If the file argument includes a revision range specification, then
only files selected by the revision range are updated, and the
highest revision in the range is used.
.IP
Normally, sync will not clobber files in the client workspace that
the user has made writable. Setting the "clobber" option in the
client spec disables this safety check.
.IP
The -f flag forces resynchronization even if the client already
has the file, and clobbers writable files. This flag doesn"t affect
open files.
.IP
The -n flag causes sync not to update the client workspace, but to
display what normally would be updated.
.TP
.B p4 triggers
.TP
.B p4 triggers -o
.TP
.B p4 triggers -i
.IP
"p4 triggers" edits the table of pre-submit triggers.
.IP
Triggers are user-defined commands that are run on the server
during changelist submission to validate the changelist. The
commands are run on the server after the changelist is created
and the files are locked but before any files are transferred.
Thus triggers cannot validate the contents of files being submitted.
.IP
The trigger form has a single entry "Triggers", followed by any
number of trigger lines. Triggers are executed in the order listed
and if a trigger fails subsequent triggers are not run. A trigger
succeeds if the command executed exits 0 and fails otherwise.
If it fails, the command"s standard output (not error output)
is used as the text of the trigger failure error message.
.IP
Each trigger line contains a trigger name, a depot file path
pattern, and a command to run:
.RS
.TP
Name:
The name of the trigger. A run of the same trigger
name on contiguous lines is treated as a single trigger,
so that multiple paths may be specified. Only the
command of the first such trigger line is used.
.RE
.RS
.TP
Path:
Files which will cause the trigger to be run. This
is a file pattern and may be an exclusion mapping (-pattern)
to exclude files.
.RE
.RS
.TP
Command:
The command to run to validate the changelist. If the
command contains spaces, the whole command must be
quoted. The following variables are expanded in the
command string:
.RE
.IP
%changelist% -- the changelist being submitted
%client% -- the client submitting the changelist
%clienthost% -- the hostname of the client
%clientip% -- the IP address of the client
%serverhost% -- the hostname of the server
%serverip% -- the IP address of the server
%serverport% -- the IP address:port of the server
%serverroot% -- the value of the server"s $P4ROOT
%user% -- the user submitting the changelist
More information can be gathered about the changelist
being submitted by running "p4 describe %changelist%".
.IP
The -o flag causes the trigger table to be written
to the standard output. The user"s editor is not invoked.
.IP
The -i flag causes the trigger table to be read from the
standard input. The user"s editor is not invoked.
.IP
"p4 triggers" requires superuser access granted by "p4 protect".
.TP
.B p4 typemap
.TP
.B p4 typemap -o
.TP
.B p4 typemap -i
.IP
"p4 typemap" edits a name-to-type mapping table for "p4 add",
which consults the table to select a file"s filetype based on
its name.
.IP
The typemap form has a single entry "TypeMap", followed by any
number of typemap lines. Each typemap line contains a filetype
and a depot file path pattern:
.RS
.TP
Filetype:
See "p4 help filetypes" for a list of valid filetypes.
.RE
.RS
.TP
Path:
Names to be mapped to the filetype. This is a file
pattern and may be an exclusion mapping (-pattern)
to exclude files. Note to match all files anywhere
in the depot hierarchy, the pattern must begin with
//..., and to match any file with a given suffix you
must either specify "//.../*.suffix" or "//....suffix"
(four dots).
.RE
.IP
As with all mappings, later entries override earlier entries.
If no matching entry is found in the table, "p4 add" senses the
file"s filetype by examining the file"s contents and execution
permission bits.
.IP
The -o flag causes the typemap table to be written
to the standard output. The user"s editor is not invoked.
.IP
The -i flag causes the typemap table to be read from the
standard input. The user"s editor is not invoked.
.IP
"p4 typemap" requires superuser access granted by "p4 protect".
.TP
.B p4 unlock [ -c changelist# ] [ file ... ]
.IP
"p4 unlock" releases a lock on an open file in a pending changelist.
If the file is open in a specific pending changelist other than
"default", then the -c flag is required to specify the pending
changelist. If no file name is given then all files in the
designated changelist are unlocked.
.TP
.B p4 user [ -f ] [ name ]
.TP
.B p4 user -d [ -f ] name
.TP
.B p4 user -o [ name ]
.TP
.B p4 user -i [ -f ]
.IP
Create a new user specification or edit an existing user
specification. The specification form is put into a temporary
file and the editor (given by the environment variable $P4EDITOR)
is invoked.
.IP
Normally, a user specification is created automatically the
first time the user invokes any client command that can update
the depot. The "p4 user" command is generally used to edit the
user"s reviewing subscription list for change review.
.IP
The user specification form contains the following fields:
.RS
.TP
User:
The user name (read only).
.RE
.RS
.TP
Email:
The user"s email address (user@client default).
.RE
.RS
.TP
Update:
The date the specification was last modified (read only).
.RE
.RS
.TP
Access:
The date the user last issued a client command.
.RE
.IP
FullName: The user"s real name.
.IP
JobView: Selects jobs to be presented at changelist creation.
These are the jobs that can be closed automatically
upon changelist submission. See "p4 help jobview"
for a description of jobview syntax.
.RS
.TP
Reviews:
The subscription list for change review. You may
use wildcards:
... matches any characters including /
* matches any character except /
There may be any number of review lines.
.RE
.RS
.TP
Password:
The user"s password. See also "p4 help passwd".
.RE
.IP
The -d flag deletes the named user, but only if the user is not
the owner of any branches, clients, jobs, labels, or opened files.
.IP
The -o flag causes the named user specification to be written
to the standard output. The user"s editor is not invoked.
.IP
The -i flag causes a user specification to be read from the
standard input. The user"s editor is not invoked.
.IP
The -f flag allows the superuser to delete or modify any user;
normally users can only be deleted or modified by themselves.
-f also allows the last modified date to be set.
.TP
.B p4 users [ user ... ]
.IP
Reports the list of all users, or those users matching the argument,
currently known to the system. The report includes the last time
each user accessed the system.
.TP
.B p4 verify [ -q -u -v ] file[revRange] ...
.IP
"p4 verify" reports for each revision of the named files the
revision specific information and an MD5 digest (fingerprint)
of the revision"s contents. See "p4 help revisions" for help
specifying revisions.
.IP
By default, "p4 verify" computes and displays the digest of each
revision. If a revision cannot be reproduced (e.g. if the file
is missing from the archive), the revision"s output line ends with
MISSING! If there is a saved digest, "p4 verify" compares it with
the computed one. If they differ the output line ends with BAD!
.IP
The -u flag causes "p4 verify" to compute and save the digest
for each revision that has no saved digest. Revisions already
with saved digests are skipped.
.IP
The -v flag forces "p4 verify" to compute and save the digest
for each revision, even if it already has a saved digest. This
can be used to update the saved digest if the archive was changed
deliberately.
.IP
The -q flag instructs "p4 verify" to operate quietly. The only
output would be errors from mismatched digests or errors due to
unreproducible revisions.
.IP
The following commands will compute digests for revisions without
saved digests and then verify the first and head revisions of all
files. Verifying revision #1 is useful for text files because
of their reverse delta storage format: corruption of any revision
will be reflected in revision #1.
.RS
.RS
.TP
p4
verify -qu //...
.RE
.RE
.RS
.RS
.TP
p4
verify -q #1,#1
.RE
.RE
.RS
.RS
.TP
p4
verify -q #head,#head
.RE
.RE
.IP
Saved digests are also used by "p4 diff" to avoid having to
compute them each time.
.IP
"p4 verify" requires superuser access granted by "p4 protect".
.TP
.B p4 where [ file ... ]
.IP
Where shows how the named files map through the client view.
For each argument, three names are produced: the name in the
depot, the name on the client in Perforce syntax, and the name
on the client in local syntax.
.IP
If no file is given, the mapping for "..." (all files in the
current directory and below) is shown.
.IP
Note that "p4 where" does not determine where any real files are.
It only computes where they should be according to the client view.
