/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (C) 2003  Jakob Henriksson <b0kaj+dev@lysator.liu.se>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "notes.h"

extern _note_applet *notes_applet;

void
cb_sticky_check_button_toggled(GtkToggleButton *button, gpointer data)
{
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)) == TRUE) {
	notes_applet->notes_sticky = TRUE;
  } else {
	notes_applet->notes_sticky = FALSE;
  }
  
  notes_update_sticky();
  
  return;
}

void
cb_notes_on_top_check_button_toggled(GtkToggleButton *button, gpointer data)
{
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)) == TRUE) {
	notes_applet->notes_on_top = TRUE;
  } else {
	notes_applet->notes_on_top = FALSE;
  }
  
  notes_update_on_top();
  
  return;
}

void
cb_system_colors_check_button_toggled(GtkToggleButton *button, gpointer data)
{
    GtkWidget *color_sel = (GtkWidget *)data;

    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)) == TRUE) {
	notes_applet->system_colors = TRUE;
	gtk_widget_set_sensitive(color_sel, FALSE);
    } else {
	notes_applet->system_colors = FALSE;
	gtk_widget_set_sensitive(color_sel, TRUE);
    }

    notes_update_colors();

    return;
}

void
cb_color_selection_set(GtkColorButton *button, gpointer data)
{
  gtk_color_button_get_color(button, &notes_applet->note_color);

  /* update the notes colors */
  notes_update_colors();

  return;
}

/* options dialog */
GtkWidget*
notes_create_applet_options (GtkContainer *con)
{
    GtkWidget *vbox, *hbox;
    GtkWidget *label;
    GtkWidget *button;

    GtkWidget *framebox;

    GtkWidget *color_vbox;
    GtkWidget *color_button;

    GdkColor color;
    
    vbox = gtk_vbox_new(FALSE, 0);
    gtk_widget_show(vbox);

    /* STICKY */

    framebox = xfce_framebox_new("Sticky", TRUE);
    gtk_box_pack_start_defaults(GTK_BOX(vbox), framebox);
    gtk_widget_show(framebox);

    button = gtk_check_button_new_with_label("Make notes sticky");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),
				 (notes_applet->notes_sticky == TRUE) ?
				 TRUE : FALSE);
    xfce_framebox_add(XFCE_FRAMEBOX(framebox), button);
    g_signal_connect(G_OBJECT(button), "toggled",
		     G_CALLBACK(cb_sticky_check_button_toggled), NULL);
    gtk_widget_show(button);

    /* WINDOWS ON TOP */

    framebox = xfce_framebox_new("On top", TRUE);
    gtk_box_pack_start_defaults(GTK_BOX(vbox), framebox);
    gtk_widget_show(framebox);

    button = gtk_check_button_new_with_label("Keep notes on top");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),
				 (notes_applet->notes_on_top == TRUE) ?
				 TRUE : FALSE);
    xfce_framebox_add(XFCE_FRAMEBOX(framebox), button);
    g_signal_connect(G_OBJECT(button), "toggled",
		     G_CALLBACK(cb_notes_on_top_check_button_toggled), NULL);
    gtk_widget_show(button);

    /* COLOR */

    framebox = xfce_framebox_new("Color", TRUE);
    gtk_box_pack_start_defaults(GTK_BOX(vbox), framebox);
    gtk_widget_show(framebox);
    
    color_vbox = gtk_vbox_new(FALSE, 0);
    gtk_widget_show(color_vbox);
    xfce_framebox_add(XFCE_FRAMEBOX(framebox), color_vbox);

    /* system color */
    button = gtk_check_button_new_with_label("Use system colors");
    /* use system colors by default */
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),
				 (notes_applet->system_colors == TRUE) ?
				 TRUE : FALSE);
    gtk_box_pack_start_defaults(GTK_BOX(color_vbox), button);
    gtk_widget_show(button);

    hbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start_defaults(GTK_BOX(color_vbox), hbox);
    gtk_widget_show(hbox);

    /* color label */
    label = gtk_label_new("Color:");
    gtk_box_pack_start_defaults(GTK_BOX(hbox), label);
    gtk_widget_show(label);
    
    color_button = gtk_color_button_new();
    gtk_widget_set_sensitive(color_button, 
			     (notes_applet->system_colors == TRUE) ?
			     FALSE : TRUE);
    /* set default color */
    gtk_color_button_set_color(GTK_COLOR_BUTTON(color_button), 
							   &notes_applet->note_color);

    gtk_widget_show(color_button);

    g_signal_connect(G_OBJECT(color_button), "color-set",
		     G_CALLBACK(cb_color_selection_set), NULL);

    gtk_box_pack_start_defaults(GTK_BOX(hbox), color_button);

    /* use system color check button */
    g_signal_connect(G_OBJECT(button), "toggled",
		     G_CALLBACK(cb_system_colors_check_button_toggled),
		     (gpointer)color_button);

    return vbox;
}


