/*
 * Copyright (c) 2006 Alvaro Lopes <alvieboy@alvie.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __MODEMDRIVER_H__
#define __MODEMDRIVER_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define HAVE_FAKE_MODEM 1

#include <glib.h>
#include "cellmodem_options.h"

typedef void * modem_instance_t;

typedef struct modem_driver_t
{
    const gchar *name;
    const gchar *description;

    /* Methods */

    modem_instance_t (*create)( );
    gboolean (*open)( modem_instance_t instance, cellmodem_options_t *options );
    gboolean (*writeln)( modem_instance_t instance, const gchar *data );
    void (*close)( modem_instance_t instance );
    gboolean (*set_reader)( modem_instance_t instance, GIOFunc reader, gpointer data );

    void (*destroy)( modem_instance_t instance );

} modem_driver_t;


modem_driver_t *find_driver_by_name( const gchar *name );
modem_driver_t *find_driver_by_index( const int idx );
int find_driver_index_by_name( const gchar *name );

extern modem_driver_t *drivers[];

#endif
