/*
 * Copyright (c) 2006 Alvaro Lopes <alvieboy@alvie.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __LEDS_H__
#define __LEDS_H__

#include <gtk/gtk.h>

typedef enum
{
    LED_OFF = 2,
    LED_GREEN = 1,
    LED_RED = 0,
    LED_YELLOW = 3
} led_color_t;

typedef struct
{
    GtkWidget *image;
    gboolean flashing;
    led_color_t color;
    gboolean flash_on;
} led_t;



led_t *led_t_new();
void led_t_set_color( led_t *led, led_color_t color );
void led_t_set_flashing( led_t *led, gboolean flashing );
void led_t_destroy( led_t *led );
void led_t_flip_flash( led_t *led , gpointer data );



#endif
