/*
 * Copyright (c) 2006 Alvaro Lopes <alvieboy@alvie.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __CELLMODEM_H__
#define __CELLMODEM_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "cellmodem.h"
#include "modem_driver.h"

#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <libxfce4util/libxfce4util.h>
#include <libxfcegui4/libxfcegui4.h>
#include <libxfce4panel/xfce-panel-plugin.h>

#include "leds.h"

#ifdef DEBUG_ENABLED
#include <syslog.h>

extern int init_logging();
extern char logbuf[8192];

#endif

/* Check every 10 seconds */

#define OPEN_TIMEOUT (10000)



#ifdef DEBUG_ENABLED
#define DEBUG(x...) do { char *tmp=logbuf; tmp+=sprintf(logbuf,"%s [%d] : ", __FUNCTION__, __LINE__); \
    tmp+=sprintf(tmp,x); \
    sprintf(tmp,"\n"); \
    syslog(LOG_DEBUG, "%s", logbuf ); \
    } while (0)
#else
#define DEBUG(x...)
#endif

#define MAX_QUAL 20
#define BORDER 8

typedef void (*modem_reply_callback_t)( gboolean success, GString *response, void  *pvt);

#if 0

typedef enum {
    MODEM_OFFLINE,
    MODEM_IDLE,
    MODEM_CLOSED,
    MODEM_ERROR
} modem_status_t;

#endif


typedef enum {
    MODEM_ERROR,
    MODEM_WAIT_CPIN_RESPONSE,
    MODEM_WAIT_CREG_RESPONSE,
    MODEM_WAIT_COPS_RESPONSE,
    MODEM_WAIT_CSQ_RESPONSE,
    MODEM_WAIT_REGISTRATION,
    MODEM_CLOSED
} modem_status_t;

typedef enum {
    REGISTRATION_UNKNOWN,
    REGISTRATION_NOT_REGISTERED,
    REGISTRATION_REGISTERING,
    REGISTRATION_GPRS,
    REGISTRATION_UMTS,
    REGISTRATION_HSDPA,
    REGISTRATION_NEEDS_PIN
} registration_type_t;


typedef struct
{
    modem_reply_callback_t reply_callback;
    void *reply_pvt;
    GString *reply_buffer;
} modem_response_data_t;

typedef struct
{
    XfcePanelPlugin *plugin;
    GtkTooltips     *tooltips;
    GtkWidget       *eventbox;
    GtkWidget       *box, *gbox;
    GtkWidget       *qualpbar;
    led_t           *status_led;
    led_t           *network_led;
    /* Colors */
    GdkColor        red_color, yellow_color, green_color;
    /* IO Stuff */

    modem_driver_t  *driver;
    modem_instance_t  *modem_instance;
    gchar           line_buffer[8192];
    size_t          line_buffer_size;

    /* User options */
    cellmodem_options_t options;

    /* Modem stuff */
    modem_status_t modem_status;
    registration_type_t registration_status;
    gfloat quality;
    gint signal_strength;
    /* Last command we sent to the modem */
    gchar *lastcmd;
    /* Network information */
    gchar *network;
    /* Last error we got */
    gchar *lasterror;

    modem_response_data_t resp;

    gint info_timeout_id;
    gint at_timeout_id;
} cellmodem_t;


/*
 Prototypes
 */
void cellmodem_write_config(XfcePanelPlugin *plugin, cellmodem_t *monitor);
void cellmodem_t_initialize_modem( cellmodem_t *monitor );


#endif

